/*
 * Decompiled with CFR 0.152.
 */
package resid;

import resid.ISIDDefs;
import resid.IWave6581;
import resid.IWave8580;
import resid.SID;

public class WaveformGenerator
implements IWave6581,
IWave8580 {
    protected WaveformGenerator sync_source = this;
    protected WaveformGenerator sync_dest = null;
    protected boolean msb_rising;
    protected int accumulator;
    protected int shift_register;
    protected int freq;
    protected int pw;
    protected int waveform;
    protected int test;
    protected int ring_mod;
    protected int sync;
    int[] wave__ST;
    int[] wave_P_T;
    int[] wave_PS_;
    int[] wave_PST;

    public WaveformGenerator() {
        this.set_chip_model(ISIDDefs.chip_model.MOS6581);
        this.reset();
    }

    public void set_sync_source(WaveformGenerator source) {
        this.sync_source = source;
        source.sync_dest = this;
    }

    public void set_chip_model(ISIDDefs.chip_model model) {
        if (model == ISIDDefs.chip_model.MOS6581) {
            this.wave__ST = wave6581__ST;
            this.wave_P_T = wave6581_P_T;
            this.wave_PS_ = wave6581_PS_;
            this.wave_PST = wave6581_PST;
        } else {
            this.wave__ST = wave8580__ST;
            this.wave_P_T = wave8580_P_T;
            this.wave_PS_ = wave8580_PS_;
            this.wave_PST = wave8580_PST;
        }
    }

    public void writeFREQ_LO(int freq_lo) {
        this.freq = this.freq & 0xFF00 | freq_lo & 0xFF;
    }

    public void writeFREQ_HI(int freq_hi) {
        this.freq = freq_hi << 8 & 0xFF00 | this.freq & 0xFF;
    }

    public void writePW_LO(int pw_lo) {
        this.pw = this.pw & 0xF00 | pw_lo & 0xFF;
    }

    public void writePW_HI(int pw_hi) {
        this.pw = pw_hi << 8 & 0xF00 | this.pw & 0xFF;
    }

    public void writeCONTROL_REG(int control) {
        this.waveform = control >> 4 & 0xF;
        this.ring_mod = control & 4;
        this.sync = control & 2;
        int test_next = control & 8;
        if (SID.ANTTI_LANKILA_PATCH) {
            if (test_next != 0 && this.test == 0) {
                this.accumulator = 0;
                int bit19 = this.shift_register >> 19 & 1;
                this.shift_register = this.shift_register & 0x7FFFFD | (bit19 ^ 1) << 1;
            } else if (test_next == 0 && this.test > 0) {
                int bit0 = (this.shift_register >> 22 ^ this.shift_register >> 17) & 1;
                this.shift_register <<= 1;
                this.shift_register &= 0x7FFFFF;
                this.shift_register |= bit0;
            }
            if (this.waveform > 8) {
                this.shift_register &= 0x2ED76B;
            }
        } else if (test_next != 0) {
            this.accumulator = 0;
            this.shift_register = 0;
        } else if (this.test != 0) {
            this.shift_register = 0x7FFFF8;
        }
        this.test = test_next;
    }

    public int readOSC() {
        return this.output() >> 4;
    }

    public void reset() {
        this.accumulator = 0;
        this.shift_register = SID.ANTTI_LANKILA_PATCH ? 0x7FFFFC : 0x7FFFF8;
        this.freq = 0;
        this.pw = 0;
        this.test = 0;
        this.ring_mod = 0;
        this.sync = 0;
        this.msb_rising = false;
    }

    public void clock() {
        if (this.test != 0) {
            return;
        }
        int accumulator_prev = this.accumulator;
        this.accumulator += this.freq;
        this.accumulator &= 0xFFFFFF;
        boolean bl = this.msb_rising = (accumulator_prev & 0x800000) == 0 && (this.accumulator & 0x800000) != 0;
        if ((accumulator_prev & 0x80000) == 0 && (this.accumulator & 0x80000) != 0) {
            int bit0 = (this.shift_register >> 22 ^ this.shift_register >> 17) & 1;
            this.shift_register <<= 1;
            this.shift_register &= 0x7FFFFF;
            this.shift_register |= bit0;
        }
    }

    public void clock(int delta_t) {
        int delta_accumulator;
        if (this.test != 0) {
            return;
        }
        int accumulator_prev = this.accumulator;
        this.accumulator += delta_accumulator;
        this.accumulator &= 0xFFFFFF;
        this.msb_rising = (accumulator_prev & 0x800000) == 0 && (this.accumulator & 0x800000) != 0;
        int shift_period = 0x100000;
        for (delta_accumulator = delta_t * this.freq; !(delta_accumulator == 0 || delta_accumulator < shift_period && ((shift_period = delta_accumulator) <= 524288 ? (this.accumulator - shift_period & 0x80000) != 0 || (this.accumulator & 0x80000) == 0 : (this.accumulator - shift_period & 0x80000) != 0 && (this.accumulator & 0x80000) == 0)); delta_accumulator -= shift_period) {
            int bit0 = (this.shift_register >> 22 ^ this.shift_register >> 17) & 1;
            this.shift_register <<= 1;
            this.shift_register &= 0x7FFFFF;
            this.shift_register |= bit0;
        }
    }

    public void synchronize() {
        if (this.msb_rising && this.sync_dest.sync != 0 && (this.sync == 0 || !this.sync_source.msb_rising)) {
            this.sync_dest.accumulator = 0;
        }
    }

    protected int output____() {
        return 0;
    }

    protected int output___T() {
        int msb = (this.ring_mod != 0 ? this.accumulator ^ this.sync_source.accumulator : this.accumulator) & 0x800000;
        return (msb != 0 ? ~this.accumulator : this.accumulator) >> 11 & 0xFFF;
    }

    protected int output__S_() {
        return this.accumulator >> 12;
    }

    protected int output_P__() {
        return this.test != 0 || this.accumulator >> 12 >= this.pw ? 4095 : 0;
    }

    protected int outputN___() {
        return (this.shift_register & 0x400000) >> 11 | (this.shift_register & 0x100000) >> 10 | (this.shift_register & 0x10000) >> 7 | (this.shift_register & 0x2000) >> 5 | (this.shift_register & 0x800) >> 4 | (this.shift_register & 0x80) >> 1 | (this.shift_register & 0x10) << 1 | (this.shift_register & 4) << 2;
    }

    protected int output__ST() {
        return this.wave__ST[this.output__S_()] << 4;
    }

    protected int output_P_T() {
        return this.wave_P_T[this.output___T() >> 1] << 4 & this.output_P__();
    }

    protected int output_PS_() {
        return this.wave_PS_[this.output__S_()] << 4 & this.output_P__();
    }

    protected int output_PST() {
        return this.wave_PST[this.output__S_()] << 4 & this.output_P__();
    }

    protected int outputN__T() {
        return 0;
    }

    protected int outputN_S_() {
        return 0;
    }

    protected int outputN_ST() {
        return 0;
    }

    protected int outputNP__() {
        return 0;
    }

    protected int outputNP_T() {
        return 0;
    }

    protected int outputNPS_() {
        return 0;
    }

    protected int outputNPST() {
        return 0;
    }

    public int output() {
        switch (this.waveform) {
            default: {
                return this.output____();
            }
            case 1: {
                return this.output___T();
            }
            case 2: {
                return this.output__S_();
            }
            case 3: {
                return this.output__ST();
            }
            case 4: {
                return this.output_P__();
            }
            case 5: {
                return this.output_P_T();
            }
            case 6: {
                return this.output_PS_();
            }
            case 7: {
                return this.output_PST();
            }
            case 8: {
                return this.outputN___();
            }
            case 9: {
                return this.outputN__T();
            }
            case 10: {
                return this.outputN_S_();
            }
            case 11: {
                return this.outputN_ST();
            }
            case 12: {
                return this.outputNP__();
            }
            case 13: {
                return this.outputNP_T();
            }
            case 14: {
                return this.outputNPS_();
            }
            case 15: 
        }
        return this.outputNPST();
    }
}

